# Flash Programmer GUI


## Installation

### Requirements
- Raspberry Pi with Python 3 installed.

### Steps
1. Replace the `flashprogrammer` dummy script with the correct compiled C program and `flashprogrammerFPGA.bin` with the FPGA binary before proceeding with the installation.
2. Clone or download the repository containing the `install_app.sh` script.
3. Run the installation script FROM THE CORRECT WORKING DIRECTORY:
   ```bash
   cd <Path where install_app.sh is>
   chmod +x install_app.sh
   ./install_app.sh
   ```

### What the Installation Does
- Creates a directory at `/opt/flashprogrammer` to store the application and its dependencies.
- Sets up a Python virtual environment in `/opt/flashprogrammer/venv`.
- Copies all Python scripts and related files (e.g., icons) into the `/opt/flashprogrammer` directory.
- Installs necessary Python dependencies within the virtual environment.
- Creates a desktop shortcut (`flashprogrammer.desktop`) in `/usr/share/applications/` for easy access.

---

## How to Use
1. **Launch the Application**:
   - Find "Flash Programmer" in your desktop's application menu and click to open it.

2. **Select a File**:
   - Use the "Select File" button to browse and select the firmware file you want to flash.
   - The selected file path will appear in the GUI.

3. **Flash the Device**:
   - Click the "Flash" button to start the flashing process.
   - Monitor the status and logs for progress and errors.

4. **View Logs**:
   - Logs are displayed in the GUI and saved to the following locations:
     - Output log: `~/.flashprogrammer/logs/output.log`
     - Error log: `~/.flashprogrammer/logs/error.log`

---

## Logs
The application saves logs for easier debugging and review:
- **Output Logs**: General application output and process logs.
- **Error Logs**: Specific errors encountered during the flashing process.

Both logs are rotated automatically to prevent excessive disk usage.

---

## Uninstallation
To uninstall the application, remove the installed files:
```bash
sudo rm -rf /opt/flashprogrammer
sudo rm -rf ~/.flashprogrammer
sudo rm /usr/share/applications/flashprogrammer.desktop
```
