import locale


# Debug flag
# Language support
LANGUAGES = {
    "en": {
        "select_file": "Select File",
        "no_file_selected": "No file selected",
        "flashing_in_progress": "Flashing in progress...",
        "flashing_completed": "Flashing completed successfully!",
        "flashing_failed": "Flashing failed. Check log for details.",
        "error": "Error",
        "error_no_file": "No file selected. Please select a file to flash.",
        "debug_mode": "DEBUG MODE ENABLED",
        "simulating_flash": "Simulating flash process:",
        "status_waiting": "Status: Waiting for file selection"
    },
    "de": {
        "select_file": "Datei auswählen",
        "no_file_selected": "Keine Datei ausgewählt",
        "flashing_in_progress": "Flashen im Gange...",
        "flashing_completed": "Flashen erfolgreich abgeschlossen!",
        "flashing_failed": "Flashen fehlgeschlagen. Details im Protokoll überprüfen.",
        "error": "Fehler",
        "error_no_file": "Keine Datei ausgewählt. Bitte wählen Sie eine Datei zum Flashen aus.",
        "debug_mode": "DEBUG-MODUS AKTIVIERT",
        "simulating_flash": "Simuliere Flash-Prozess:",
        "status_waiting": "Status: Warten auf Dateiauswahl"
    }
}


# Determine system language
def get_system_language():
    try:
        lang_code, _ = locale.getlocale()
        if lang_code and lang_code.startswith("de"):
            return "de"
    except Exception:
        pass
    return "en"


CURRENT_LANGUAGE = get_system_language()


# Helper to get text in the current language
def _(key):
    return LANGUAGES[CURRENT_LANGUAGE].get(key, key)