--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:   10:44:08 11/15/2024
-- Design Name:   
-- Module Name:   /home/jk/Dokumente/Thales_Flashprogrammer_v3/ISE/FPGA/flashprogrammer-fpga/TB_flashprogrammer-fpga/TB_flashprogrammer-fpga.vhd
-- Project Name:  TB_flashprogrammer-fpga
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: flashprogrammerFPGA
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
 
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--USE ieee.numeric_std.ALL;
 
ENTITY TB_flashprogrammerfpga IS
END TB_flashprogrammerfpga;
 
ARCHITECTURE behavior OF TB_flashprogrammerfpga IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT flashprogrammerFPGA
    PORT(
         i_clk_fpga : IN  std_logic;
         o_led1 : OUT  std_logic;
         o_led2 : OUT  std_logic;
         i_cclk_rpi : IN  std_logic;
         i_serial_out_rpi : IN  std_logic;
         o_serial_in_rpi : OUT  std_logic;
         i_serial_ceo_rpi : IN  std_logic;
         o_data_verify_ok_rpi : OUT  std_logic;
         o_Adress : OUT  std_logic_vector(25 downto 0);
         o_Data : OUT  std_logic_vector(15 downto 0);
         i_Data : IN  std_logic_vector(15 downto 0);
         i_CD_N : IN  std_logic_vector(7 downto 0);
         i_BVD1 : IN  std_logic;
         o_CE : OUT  std_logic_vector(3 downto 0);
         o_OE : OUT  std_logic;
         o_WE_L : OUT  std_logic;
         o_WE_H : OUT  std_logic;
         o_REG : OUT  std_logic;
         o_RST : OUT  std_logic;
         o_VPP_CNT : OUT  std_logic;
         o_VCC_CNT : OUT  std_logic;
         i_BVD2 : IN  std_logic;
         o_VID : OUT  std_logic;
         o_BEEP : OUT  std_logic;
         o_DATOE : OUT  std_logic
        );
    END COMPONENT;
    

   --Inputs
   signal i_clk_fpga : std_logic := '0';
   signal i_cclk_rpi : std_logic := '0';
   signal i_serial_out_rpi : std_logic := '0';
   signal i_serial_ceo_rpi : std_logic := '0';
   signal i_Data : std_logic_vector(15 downto 0) := (others => '0');
   signal i_CD_N : std_logic_vector(7 downto 0) := (others => '0');
   signal i_BVD1 : std_logic := '0';
   signal i_BVD2 : std_logic := '0';

 	--Outputs
   signal o_led1 : std_logic;
   signal o_led2 : std_logic;
   signal o_serial_in_rpi : std_logic;
   signal o_data_verify_ok_rpi : std_logic;
   signal o_Adress : std_logic_vector(25 downto 0);
   signal o_Data : std_logic_vector(15 downto 0);
   signal o_CE : std_logic_vector(3 downto 0);
   signal o_OE : std_logic;
   signal o_WE_L : std_logic;
   signal o_WE_H : std_logic;
   signal o_REG : std_logic;
   signal o_RST : std_logic;
   signal o_VPP_CNT : std_logic;
   signal o_VCC_CNT : std_logic;
   signal o_VID : std_logic;
   signal o_BEEP : std_logic;
   signal o_DATOE : std_logic;
   -- No clocks detected in port list. Replace <clock> below with 
   -- appropriate port name 
 
   constant i_clk_fpga_period : time := 40 ns;
	constant i_cclk_rpi_period : time := 200 ns;

	procedure rpi_send_packet (
		constant data_in : in std_logic_vector;
		signal i_serial_out_rpi : out std_logic;
		signal i_serial_ceo_rpi : out std_logic;
		signal i_cclk_rpi : out std_logic
	) is
		alias in_data : std_logic_vector(31 downto 0) is data_in;
	begin
		i_serial_ceo_rpi <= '0';
		wait for 12000 ns;
		
		-- First Byte
		i_serial_out_rpi <= in_data(31); -- First Bit
		wait for 250 ns;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(30);	-- Second Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(29);	-- Third Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(28);	-- Fourth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(27);	-- Fifth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(26);	-- Sixth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(25);	-- Seventh Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(24);	-- Eigth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= '0';
		wait for i_cclk_rpi_period;

		wait for 250 ns;
		
		-- Second Byte
		i_serial_out_rpi <= in_data(23); -- First Bit
		wait for 250 ns;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(22);	-- Second Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(21);	-- Third Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(20);	-- Fourth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(19);	-- Fifth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(18);	-- Sixth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(17);	-- Seventh Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(16);	-- Eigth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= '0';
		wait for i_cclk_rpi_period;

		wait for 250 ns;
		
		-- Third Byte
		i_serial_out_rpi <= in_data(15); -- First Bit
		wait for 250 ns;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(14);	-- Second Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(13);	-- Third Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(12);	-- Fourth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(11);	-- Fifth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(10);	-- Sixth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(9);	-- Seventh Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(8);	-- Eigth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= '0';
		wait for i_cclk_rpi_period;

		wait for 250 ns;
		
		-- Fourth Byte
		i_serial_out_rpi <= in_data(7); -- First Bit
		wait for 250 ns;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(6);	-- Second Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(5);	-- Third Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(4);	-- Fourth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(3);	-- Fifth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(2);	-- Sixth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(1);	-- Seventh Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= in_data(0);	-- Eigth Bit
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		i_serial_out_rpi <= '0';
		wait for i_cclk_rpi_period;

		wait for 250 ns;
		
		wait for 1650 ns;
		i_serial_ceo_rpi <= '1';
		wait for 10000 ns;
	end procedure rpi_send_packet;
		
	procedure rpi_rcv_packet (
		signal i_serial_ceo_rpi : out std_logic;
		signal i_cclk_rpi : out std_logic
	) is
	begin
		i_serial_ceo_rpi <= '0';
		wait for 10000 ns;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		
		wait for 250 ns;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '1';
		wait for i_cclk_rpi_period;
		i_cclk_rpi <= '0';
		wait for i_cclk_rpi_period;
		
		wait for 1000 ns;
		i_serial_ceo_rpi <= '1';
		wait for 12000 ns;
	end procedure rpi_rcv_packet;

BEGIN
 
	i_CD_N <= x"7E";
 
	-- Instantiate the Unit Under Test (UUT)
   uut: flashprogrammerFPGA PORT MAP (
          i_clk_fpga => i_clk_fpga,
          o_led1 => o_led1,
          o_led2 => o_led2,
          i_cclk_rpi => i_cclk_rpi,
          i_serial_out_rpi => i_serial_out_rpi,
          o_serial_in_rpi => o_serial_in_rpi,
          i_serial_ceo_rpi => i_serial_ceo_rpi,
          o_data_verify_ok_rpi => o_data_verify_ok_rpi,
          o_Adress => o_Adress,
          o_Data => o_Data,
          i_Data => i_Data,
          i_CD_N => i_CD_N,
          i_BVD1 => i_BVD1,
          o_CE => o_CE,
          o_OE => o_OE,
          o_WE_L => o_WE_L,
          o_WE_H => o_WE_H,
          o_REG => o_REG,
          o_RST => o_RST,
          o_VPP_CNT => o_VPP_CNT,
          o_VCC_CNT => o_VCC_CNT,
          i_BVD2 => i_BVD2,
          o_VID => o_VID,
          o_BEEP => o_BEEP,
          o_DATOE => o_DATOE
        );

   -- Clock process definitions
   i_clk_fpga_process :process
   begin
		i_clk_fpga <= '0';
		wait for i_clk_fpga_period/2;
		i_clk_fpga <= '1';
		wait for i_clk_fpga_period/2;
   end process;
 

   -- Stimulus process
   stim_proc: process
   begin		
      -- hold reset state for 100 ns.
      wait for 100 ns;	

      wait for i_clk_fpga_period*10;

      -- insert stimulus here
		rpi_send_packet(x"FFFFFF3C", i_serial_out_rpi, i_serial_ceo_rpi, i_cclk_rpi);
		rpi_send_packet(x"00000050", i_serial_out_rpi, i_serial_ceo_rpi, i_cclk_rpi);
		rpi_send_packet(x"FFA50090", i_serial_out_rpi, i_serial_ceo_rpi, i_cclk_rpi);
		rpi_send_packet(x"FFA00090", i_serial_out_rpi, i_serial_ceo_rpi, i_cclk_rpi);
		rpi_send_packet(x"FFA20090", i_serial_out_rpi, i_serial_ceo_rpi, i_cclk_rpi);
		rpi_send_packet(x"FF420090", i_serial_out_rpi, i_serial_ceo_rpi, i_cclk_rpi);
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		
		rpi_send_packet(x"FCB20090", i_serial_out_rpi, i_serial_ceo_rpi, i_cclk_rpi);
		rpi_send_packet(x"00000030", i_serial_out_rpi, i_serial_ceo_rpi, i_cclk_rpi);
		rpi_send_packet(x"00000008", i_serial_out_rpi, i_serial_ceo_rpi, i_cclk_rpi);
		rpi_send_packet(x"00000000", i_serial_out_rpi, i_serial_ceo_rpi, i_cclk_rpi);
		rpi_send_packet(x"FE7F0000", i_serial_out_rpi, i_serial_ceo_rpi, i_cclk_rpi);
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		i_Data <= "1000000010000000";
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		rpi_rcv_packet(i_serial_ceo_rpi, i_cclk_rpi);
		

      wait;
   end process;

END;