----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    15:08:56 10/17/2024 
-- Design Name: 
-- Module Name:    new_spi_test_1024 - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity flashprogrammerFPGA is
	port (
		-- Quarz (25 MHz)
		i_clk_fpga			: in std_logic;
		-- LEDs
		o_led1				: out std_logic;
		o_led2				: out std_logic;
		-- SPI (Data)
		i_cclk_rpi			: in std_logic;	-- SPI clk
		i_serial_out_rpi	: in std_logic;	-- SPI MOSI
		o_serial_in_rpi	: out std_logic;	-- SPI MISO
		i_serial_ceo_rpi	: in std_logic;	-- SPI CS
		o_data_verify_ok_rpi	: out std_logic;
		-- Card Pins
		o_Adress				: out std_logic_vector(25 downto 0);	-- Address
		o_Data				: out std_logic_vector(15 downto 0);	-- DataOut
		i_Data				: in std_logic_vector(15 downto 0);		-- DataInput
		i_CD_N				: in std_logic_vector(7 downto 0);		-- CardType
		i_BVD1				: in std_logic;								-- PrgDetect1 (Battery Voltage Detect 1)
		o_CE					: out std_logic_vector(3 downto 0);		-- ChipEnable
		o_OE					: out std_logic;								-- OutputEnable
		o_WE_L				: out std_logic;								-- WriteEnable_L
		o_WE_H				: out std_logic;								-- WriteEnable_H
		o_REG					: out std_logic;								-- Reg (Register Select)
		o_RST					: out std_logic;								-- Reset
		o_VPP_CNT			: out std_logic;								-- Vpp (VPP Control)
		o_VCC_CNT			: out std_logic;								-- Vcc (VCC Control)
		i_BVD2				: in std_logic;								-- PrgDetect2 (Battery Voltage Detect 2)
		o_VID					: out std_logic;								-- VppA9	?????
		o_BEEP				: out std_logic;								-- PrgBeep
		o_DATOE				: out std_logic								-- PrgDataDirection
	);
end flashprogrammerFPGA;

architecture Behavioral of flashprogrammerFPGA is

	component clk_gen is
		port (
			-- Clock in ports
			CLK_IN1			: in std_logic;
			-- Clock out ports
			CLK_OUT1			: out std_logic;
			-- Status and control signal
			RESET				: in std_logic;
			LOCKED			: out std_logic
		);
	end component clk_gen;



	signal clk : std_logic := '0';
	signal reset : std_logic := '0';
	signal clk_locked : std_logic := '0';
	signal n_rst : std_logic := '1';

	signal tx_data : std_logic_vector(15 downto 0);
	signal tx_data_ready : std_logic;
	signal tx_new_data_ready : std_logic;
	signal rx_data : std_logic_vector(15 downto 0);
	signal rx_data_ready : std_logic;

begin

	inst_clk_gen : component clk_gen
		port map (
			CLK_IN1		=> i_clk_fpga,
			CLK_OUT1		=> clk,
			RESET			=> reset,
			LOCKED		=> clk_locked
		);
	
	inst_spi_slave : entity work.SPI_SLAVE
		generic map (
			WORD_SIZE => 16
		)
		port map (
			CLK			=> clk,
			RST			=> reset,
			SCLK			=> i_cclk_rpi,
			CS_N			=> i_serial_ceo_rpi,
			MOSI			=> i_serial_out_rpi,
			MISO			=> o_serial_in_rpi,
			DIN			=> tx_data,
			DIN_VLD		=> tx_data_ready,
			DIN_RDY		=> tx_new_data_ready,
			DOUT			=> rx_data,
			DOUT_VLD		=> rx_data_ready
		);
	
	--inst_spi_slave : entity work.spi_slave_v4
	--	generic map(
	--		WORD_SIZE => 16
	--	)
	--	port map(
	--		clk				=> clk,
	--		n_rst				=> n_rst,
	--		sclk				=> i_cclk_rpi,
	--		mosi				=> i_serial_out_rpi,
	--		miso				=> o_serial_in_rpi,
	--		cs					=> i_serial_ceo_rpi,
	--		rx_data			=> rx_data,
	--		rx_data_ready	=> rx_data_ready,
	--		tx_data			=> tx_data,
	--		tx_data_valid	=> tx_data_ready,
	--		tx_data_ready	=> tx_new_data_ready
	--	);
	
	inst_fsm : entity work.FSM_SMALL
		port map (
			clk					=>	clk,
			n_rst					=> n_rst,
			-- SPI DATA
			rx_data				=> rx_data,
			rx_data_ready		=> rx_data_ready,
			tx_data				=> tx_data,
			tx_data_ready		=> tx_data_ready,
			tx_new_data_ready	=> tx_new_data_ready,
			-- LEDs
			led_drive_1			=> o_led1,
			led_drive_2			=> o_led2,
			-- PINs (OUT)
			Adress				=> o_Adress,
			DataOut				=> o_Data,
			CE						=> o_CE,
			OE						=> o_OE,
			WE_L					=> o_WE_L,
			WE_H					=> o_WE_H,
			REG					=> o_REG,
			RST					=> o_RST,
			VPP_CNT				=> o_VPP_CNT,
			VCC_CNT				=> o_VCC_CNT,
			BEEP					=> o_BEEP,
			DATOE					=> o_DATOE,
			VID					=> o_VID,
			data_verify_ok		=> o_data_verify_ok_rpi,
			-- PINs (IN)
			DataIn				=> i_Data,
			CD_N					=> i_CD_N,
			BVD1					=> i_BVD1,
			BVD2					=> i_BVD2
		);

			
	n_rst <= not reset;

	--o_data_verify_ok_rpi <= '0';

end Behavioral;

