----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    10:18:52 10/18/2024 
-- Design Name: 
-- Module Name:    fsm_small - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity fsm_small is
	port (
		clk					: in std_logic;
		n_rst					: in std_logic;
		-- SPI DATA
		rx_data				: in std_logic_vector(15 downto 0);
		rx_data_ready		: in std_logic;
		tx_data				: out std_logic_vector(15 downto 0);
		tx_data_ready		: out std_logic;
		tx_new_data_ready	: in std_logic;
		-- LEDs
		led_drive_1			: out std_logic;
		led_drive_2			: out std_logic;
		-- PINs (OUT)
		Adress				: out std_logic_vector(25 downto 0);
		DataOut				: out std_logic_vector(15 downto 0);
		CE						: out std_logic_vector(3 downto 0);
		OE						: out std_logic;
		WE_L					: out std_logic;
		WE_H					: out std_logic;
		REG					: out std_logic;
		RST					: out std_logic;
		VPP_CNT				: out std_logic;
		VCC_CNT				: out std_logic;
		BEEP					: out std_logic;
		DATOE					: out std_logic;
		VID					: out std_logic;
		data_verify_ok		: out std_logic;
		-- PINs (IN)
		DataIn				: in std_logic_vector(15 downto 0);
		CD_N					: in std_logic_vector(7 downto 0);
		BVD1					: in std_logic;
		BVD2					: in std_logic
	);
end fsm_small;

architecture Behavioral of fsm_small is

	signal rx_data_ready_sync : std_logic;
	signal rx_data_ready_strobe : std_logic;

	signal shift_reg : std_logic_vector(31 downto 0);
	signal shift_reg_ready : std_logic;
	signal shift_reg_ready_sync : std_logic;
	signal shift_reg_ready_strobe : std_logic;

	signal byte_cnt : unsigned(3 downto 0) := (others => '0');
	signal byte_cnt_max : std_logic;
	signal remove_tx_byte : std_logic := '0';
	signal tx_byte_removed : std_logic := '0';
	signal send_byte : std_logic := '0';
	
	type t_State is (SetPins, ReadPins1, E1, E2, WriteV200Init, WriteV200EndAdress, WriteV200_OE,
							WriteV200_ClearStatus_data, WriteV200_ClearStatus_WE0, WriteV200_ClearStatus_WE1,
							WriteV200_WordWrite_data, WriteV200_WordWrite_WE0, WriteV200_WordWrite_WE1,
							WriteV200_WriteData_get, WriteV200_WriteData_data, WriteV200_WriteData_WE0, WriteV200_WriteData_WE1,
							WriteV200_ReadStatus_OE0, WriteV200_ReadStatus_checkData, WriteV200_StatusOK, WriteV200_ReadStatus_getData,
							WriteV200_done, ERROR_WRITE, ERROR_VPP);
	signal State : t_State := SetPins;
	signal nextState : t_State;

	signal cd_meta : std_logic_vector(7 downto 0);
	signal cd_sync : std_logic_vector(7 downto 0);

	signal first_trans_done : std_logic := '0';
	signal nGet_cd : std_logic := '0';

	signal Adress_SR	: std_logic_vector(25 downto 0);
	signal DataOut_SR	: std_logic_vector(15 downto 0);
	signal CE_SR		: std_logic_vector(3 downto 0);
	signal OE_SR		: std_logic;
	signal WE_L_SR		: std_logic;
	signal WE_H_SR		: std_logic;
	signal REG_SR		: std_logic;
	signal RST_SR		: std_logic;
	signal VPP_CNT_SR	: std_logic;
	signal VCC_CNT_SR	: std_logic;
	signal BEEP_SR		: std_logic;
	signal DATOE_SR	: std_logic;

	signal Adress_SM	: std_logic_vector(25 downto 0);
	signal DataOut_SM	: std_logic_vector(15 downto 0);
	signal CE_SM		: std_logic_vector(3 downto 0);
	signal OE_SM		: std_logic;
	signal WE_L_SM		: std_logic;
	signal WE_H_SM		: std_logic;
	signal REG_SM		: std_logic;
	signal RST_SM		: std_logic;
	signal VPP_CNT_SM	: std_logic;
	signal VCC_CNT_SM	: std_logic;
	signal BEEP_SM		: std_logic;
	signal DATOE_SM	: std_logic;

	signal write_data : std_logic := '0';
	signal startAdress : std_logic_vector(25 downto 0);
	signal endAdress : std_logic_vector(25 downto 0);

	signal data_to_write : std_logic_vector(15 downto 0);

	signal status : std_logic_vector(15 downto 0);
	signal get_status : std_logic;
	signal get_status_sync : std_logic;
	signal get_status_strobe : std_logic;
	signal reset_status : std_logic;

	signal get_start_adress : std_logic := '0';
	signal get_start_adress_sync : std_logic := '0';
	signal get_start_adress_strobe : std_logic := '0';
	signal get_end_adress : std_logic := '0';
	signal get_end_adress_sync : std_logic := '0';
	signal get_end_adress_strobe : std_logic := '0';
	signal inc_start_adress : std_logic := '0';
	signal inc_start_adress_sync : std_logic := '0';
	signal inc_start_adress_strobe : std_logic := '0';

	signal delay : std_logic;
	constant c_DELAY_COUNTER_MAX : natural := 15;
	signal delay_counter : natural range 0 to c_DELAY_COUNTER_MAX := 0;

	signal delay_short : std_logic;
	constant c_DELAY_COUNTER_SHORT_MAX : natural := 3;
	signal delay_counter_short : natural range 0 to c_DELAY_COUNTER_SHORT_MAX := 0;

	--signal data_verify_ok : std_logic := '0';

begin
	
	sync_signals : process(clk) is
	begin
		if rising_edge(clk) then
			rx_data_ready_sync <= rx_data_ready;
			shift_reg_ready_sync <= shift_reg_ready;
			cd_meta <= CD_N;
			cd_sync <= cd_meta;
			inc_start_adress_sync <= inc_start_adress;
			get_start_adress_sync <= get_start_adress;
			get_end_adress_sync <= get_end_adress;
			get_status_sync <= get_status;
		end if;
	end process sync_signals;
	
	first_transmission: process(clk) is
	begin
		if rising_edge(clk) then
			if first_trans_done = '1' then
				nGet_cd <= '1';
			end if;
		end if;
	end process first_transmission;
	
	rx_data_ready_strobe_process : process(clk) is
	begin
		if rising_edge(clk) then
			if rx_data_ready /= rx_data_ready_sync and rx_data_ready = '1' then
				rx_data_ready_strobe <= '1';
			else
				rx_data_ready_strobe <= '0';
			end if;
		end if;
	end process rx_data_ready_strobe_process;
	
	shift_reg_ready_strobe_process : process(clk) is
	begin
		if rising_edge(clk) then
			if shift_reg_ready /= shift_reg_ready_sync and shift_reg_ready = '1' then
				shift_reg_ready_strobe <= '1';
			else
				shift_reg_ready_strobe <= '0';
			end if;
		end if;
	end process shift_reg_ready_strobe_process;
	
	inc_start_adress_strobe_process : process(clk) is
	begin
		if rising_edge(clk) then
			if inc_start_adress /= inc_start_adress_sync and inc_start_adress = '1' then
				inc_start_adress_strobe <= '1';
			else
				inc_start_adress_strobe <= '0';
			end if;
			
			if get_start_adress /= get_start_adress_sync and get_start_adress = '1' then
				get_start_adress_strobe <= '1';
			else
				get_start_adress_strobe <= '0';
			end if;
			
			if get_end_adress /= get_end_adress_sync and get_end_adress = '1' then
				get_end_adress_strobe <= '1';
			else
				get_end_adress_strobe <= '0';
			end if;
			
			if get_status /= get_status_sync and get_status = '1' then
				get_status_strobe <= '1';
			else
				get_status_strobe <= '0';
			end if;
		end if;
	end process inc_start_adress_strobe_process;
	
	
	rx_data_process : process(clk) is
	begin
		if rising_edge(clk) then
			if rx_data_ready_strobe = '1' then
				shift_reg <= shift_reg(15 downto 0) & rx_data;
			end if;
		end if;
	end process rx_data_process;
	
	rx_byte_count_process : process(clk) is
	begin
		if rising_edge(clk) then
			if rx_data_ready_strobe = '1' then
				if write_data = '0' then
					if byte_cnt_max = '1' then
						byte_cnt <= (others => '0');
						tx_byte_removed <= '0';
						shift_reg_ready <= '1';
					elsif remove_tx_byte = '1' then
						byte_cnt <= (others => '0');
						tx_byte_removed <= '1';
					else
						byte_cnt <= byte_cnt + 1;
						tx_byte_removed <= '0';
						shift_reg_ready <= '0';
					end if;
				else
					data_to_write(15 downto 8) <= rx_data(7 downto 0);
					data_to_write(7 downto 0) <= rx_data(15 downto 8);
				end if;
			end if;
		end if;
	end process rx_byte_count_process;
	
	byte_cnt_max <= '1' when byte_cnt = 1 else '0';

	tx_data_ready <= send_byte;

	remove_tx_byte_process : process(clk) is
	begin
		if rising_edge(clk) then
			if send_byte = '1' then
				first_trans_done <= '1';
				remove_tx_byte <= '1';
			elsif tx_byte_removed = '1' then
				remove_tx_byte <= '0';
			end if;
		end if;
	end process remove_tx_byte_process;

	start_end_adress_process : process(clk) is
	begin
		if rising_edge(clk) then
			if get_start_adress_strobe = '1' then
				startAdress(25 downto 24)		<= shift_reg(1 downto 0);
				startAdress(23 downto 16)		<= shift_reg(15 downto 8);
				startAdress(15 downto 8)		<= shift_reg(23 downto 16);
				startAdress(7 downto 0)		<= shift_reg(31 downto 24);
			elsif get_end_adress_strobe = '1' then
				endAdress(25 downto 24)		<= shift_reg(1 downto 0);
				endAdress(23 downto 16)		<= shift_reg(15 downto 8);
				endAdress(15 downto 8)		<= shift_reg(23 downto 16);
				endAdress(7 downto 0)		<= shift_reg(31 downto 24);
			elsif inc_start_adress_strobe = '1' then
				startAdress <= std_logic_vector(unsigned(startAdress) +2);
			end if;
		end if;
	end process start_end_adress_process;

	get_status_process : process(clk)is
	begin
		if rising_edge(clk) then
			if reset_status = '1' then
				status <= (others => '0');
			elsif get_status_strobe = '1' then
				status <= DataIn;
			end if;
		end if;
	end process get_status_process;

	pin_process : process(clk) is
	begin
		if rising_edge(clk) then
			if shift_reg_ready_strobe = '1' then
				--led_drive_1 <= '0';
				--led_drive_2 <= '0';
				if shift_reg(4) = '1' and shift_reg(5) = '1' and shift_reg(6) = '0' and shift_reg(7) = '0' then
					-- Adress packet
					Adress_SR(25 downto 24)		<= shift_reg(1 downto 0);
					Adress_SR(23 downto 16)		<= shift_reg(15 downto 8);
					Adress_SR(15 downto 8)		<= shift_reg(23 downto 16);
					Adress_SR(7 downto 0)		<= shift_reg(31 downto 24);
					--led_drive_1 <= '1';
				elsif shift_reg(4) = '1' and shift_reg(5) = '0' and shift_reg(6) = '1' and shift_reg(7) = '0' then
					-- Data packet
					DataOut_SR(15 downto 8)		<= shift_reg(23 downto 16);
					DataOut_SR(7 downto 0)		<= shift_reg(31 downto 24);
					--led_drive_2 <= '1';
				elsif shift_reg(4) = '1' and shift_reg(5) = '0' and shift_reg(6) = '0' and shift_reg(7) = '1' then
					-- Config packet
					CE_SR							<= shift_reg(27 downto 24);
					OE_SR							<= shift_reg(28);
					WE_L_SR						<= shift_reg(29);
					WE_H_SR						<= shift_reg(30);
					REG_SR						<= shift_reg(31);
					RST_SR						<= shift_reg(16);
					VPP_CNT_SR					<= shift_reg(17);
					VCC_CNT_SR					<= shift_reg(18);
					VID							<= '0';
					BEEP_SR						<= shift_reg(19);
					DATOE_SR						<= shift_reg(20);
					--led_drive_1 <= '1';
					--led_drive_2 <= '1';
				end if;
			end if;
		end if;
	end process pin_process;
	
	Adress 	<= Adress_SR when write_data = '0' else Adress_SM;
	DataOut	<= DataOut_SR when write_data = '0' else DataOut_SM;
	CE			<= CE_SR when write_data = '0' else CE_SM;
	OE			<= OE_SR when write_data = '0' else OE_SM;
	WE_L		<= WE_L_SR when write_data = '0' else WE_L_SM;
	WE_H		<= WE_H_SR when write_data = '0' else WE_H_SM;
	REG		<= REG_SR when write_data = '0' else REG_SM;
	RST		<= RST_SR when write_data = '0' else RST_SM;
	VPP_CNT	<= VPP_CNT_SR when write_data = '0' else VPP_CNT_SM;
	VCC_CNT	<= VCC_CNT_SR when write_data = '0' else VCC_CNT_SM;
	BEEP		<= BEEP_SR when write_data = '0' else BEEP_SM;
	DATOE		<= DATOE_SR when write_data = '0' else DATOE_SM;
	
	delay_proc : process(clk) is
	begin
		if rising_edge(clk) then
			if delay = '1' then
				delay_counter <= delay_counter + 1;
			else
				delay_counter <= 0;
			end if;
			
			if delay_short = '1' then
				delay_counter_short <= delay_counter_short + 1;
			else
				delay_counter_short <= 0;
			end if;
		end if;
	end process delay_proc;
	
	
	fsm_seq : process(clk) is
	begin
		if rising_edge(clk) then
			State <= nextState;
		end if;
	end process fsm_seq;
	
	fsm_comb: process(State, shift_reg_ready_strobe, shift_reg, DataIn, tx_new_data_ready, cd_sync, nGet_cd,
							rx_data_ready_strobe, startAdress, endAdress, delay_counter, delay_counter_short, rx_data, data_to_write, status) is
	begin
		nextState <= State;
		
		led_drive_1 <= '0';
		led_drive_2 <= '0';
		
		tx_data <= (others => '0');
		send_byte <= '0';
		write_data <= '0';
		
		get_start_adress <= '0';
		get_end_adress <= '0';
		inc_start_adress <= '0';
		
		reset_status <= '0';
		get_status <= '0';
		
		delay <= '0';
		delay_short <= '0';
		
		data_verify_ok <= '0';
		
		Adress_SM 	<= (others => '0');
		DataOut_SM 	<= (others => '0');
		CE_SM			<= (others => '1');
		OE_SM			<= '1';
		WE_L_SM		<= '1';
		WE_H_SM		<= '1';
		REG_SM		<= '1';
		RST_SM		<= '0';
		VPP_CNT_SM	<= '1';
		VCC_CNT_SM	<= '0';
		BEEP_SM		<= '0';
		DATOE_SM		<= '0';
		
		case State is
		--when Init =>
		--	if shift_reg_ready_strobe = '1' then
				--if shift_reg(63 downto 56) = x"00" then
				--if shift_reg(55 downto 48) = x"00" then
				--if shift_reg(47 downto 40) = x"FF" then
				--if shift_reg(39 downto 32) = x"00" then
				--if shift_reg(31 downto 24) = x"00" then
				--if shift_reg(23 downto 16) = x"00" then
				--if shift_reg(15 downto 8) = x"00" then
				--if shift_reg(7 downto 0) = x"00" then
				--if shift_reg(63 downto 0) = x"0000FFFFFF0000FF" then
		--		if shift_reg(63 downto 0) = x"00FFFFFF0000FFA5" then
		--			nextState <= SetPins;
		--		else
		--			nextState <= E1;
		--		end if;
		--	end if;
		
		when SetPins =>
			--led_drive_1 <= '1';
			if shift_reg_ready_strobe = '1' then
				if shift_reg(4) = '1' and shift_reg(5) = '0' and shift_reg(6) = '0' and shift_reg(7) = '1' then
					if shift_reg(21) = '0' and shift_reg(22) = '1' and shift_reg(23) = '0' then
						nextState <= ReadPins1;
					end if;
				elsif shift_reg(3) = '1' and shift_reg(4) = '0' and shift_reg(5) = '0' and shift_reg(6) = '0' and shift_reg(7) = '0' then
					nextState <= WriteV200Init;
				end if;
			end if;
			
		when ReadPins1 =>
			--led_drive_1 <= '1';
			--led_drive_2 <= '1';
			if tx_new_data_ready = '1' then
				if nGet_cd = '1' then
					--led_drive_1 <= '1';
					tx_data <= DataIn(15 downto 0);
				else
					--led_drive_2 <= '1';
					tx_data <= cd_sync & cd_sync;
				end if;
				send_byte <= '1';
				--nextState <= SetPins;
			end if;
			if rx_data_ready_strobe = '1' then
				nextState <= SetPins;
			end if;
		
		when WriteV200Init =>
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			
			if shift_reg_ready_strobe = '1' then
				get_start_adress <= '1';
				nextState <= WriteV200EndAdress;
			end if;
			
		when WriteV200EndAdress =>
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			
			get_start_adress <= '1';
			
			if shift_reg_ready_strobe = '1' then
				get_end_adress <= '1';
				nextState <= WriteV200_OE;
			end if;
			
		when WriteV200_OE =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			get_end_adress <= '1';
			
			delay_short <= '1';
			if delay_counter_short = c_DELAY_COUNTER_SHORT_MAX then
				nextState <= WriteV200_ClearStatus_data;
				delay_short <= '0';
			end if;
			
		when WriteV200_ClearStatus_data =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			DataOut_SM <= x"5050";
			
			--if startAdress = b"00000000000000000000000000" then
			--if endAdress = b"00000000000000000000000000" then
			--	led_drive_1 <= '1';
			--else
			--	led_drive_2 <= '1';
			--end if;
			reset_status <= '1';
			
			delay_short <= '1';
			if delay_counter_short = c_DELAY_COUNTER_SHORT_MAX then
				nextState <= WriteV200_ClearStatus_WE0;
				delay_short <= '0';
			end if;
			
		when WriteV200_ClearStatus_WE0 =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			DataOut_SM <= x"5050";
			WE_L_SM <= '0';
			WE_H_SM <= '0';
			
			delay <= '1';
			if delay_counter = c_DELAY_COUNTER_MAX then
				nextState <= WriteV200_ClearStatus_WE1;
				delay <= '0';
			end if;
		
		when WriteV200_ClearStatus_WE1 =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			DataOut_SM <= x"5050";
			WE_L_SM <= '1';
			WE_H_SM <= '1';
			
			delay_short <= '1';
			if delay_counter_short = c_DELAY_COUNTER_SHORT_MAX then
				nextState <= WriteV200_WordWrite_data;
				delay_short <= '0';
			end if;
			
			
		when WriteV200_WordWrite_data =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			DataOut_SM <= x"4040";
			--DataOut_SM <= x"7263";
			
			delay <= '1';
			if delay_counter = c_DELAY_COUNTER_MAX then
				nextState <= WriteV200_WordWrite_WE0;
				delay <= '0';
			end if;
			
		when WriteV200_WordWrite_WE0 =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			DataOut_SM <= x"4040";
			--DataOut_SM <= x"7263";
			WE_L_SM <= '0';
			WE_H_SM <= '0';
			
			delay <= '1';
			if delay_counter = c_DELAY_COUNTER_MAX then
				nextState <= WriteV200_WordWrite_WE1;
				delay <= '0';
			end if;
			
		when WriteV200_WordWrite_WE1 =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			DataOut_SM <= x"4040";
			--DataOut_SM <= x"7263";
			WE_L_SM <= '1';
			WE_H_SM <= '1';
			
			delay_short <= '1';
			if delay_counter_short = c_DELAY_COUNTER_SHORT_MAX then
				nextState <= WriteV200_WriteData_get;
				delay_short <= '0';
			end if;
			
		when WriteV200_WriteData_get =>
			write_Data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			
			data_verify_ok <= '1';
			
			if rx_data_ready_strobe = '1' then
				DataOut_SM(15 downto 8)	<= rx_data(7 downto 0);
				DataOut_SM(7 downto 0)	<= rx_data(15 downto 8);
				--if rx_data = x"4AC4" then
				--	nextState <= E1;
				--elsif rx_data = x"C44A" then
				--	nextState <= E2;
				--else
					nextstate <= WriteV200_WriteData_data;
				--end if;
			end if;
		
		when WriteV200_WriteData_data =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			DataOut_SM <= data_to_write;
			
			delay <= '1';
			if delay_counter = c_DELAY_COUNTER_MAX then
				nextState <= WriteV200_WriteData_WE0;
				delay <= '0';
			end if;
		
		when WriteV200_WriteData_WE0 =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			DataOut_SM <= data_to_write;
			WE_L_SM <= '0';
			WE_H_SM <= '0';
			
			delay <= '1';
			if delay_counter = c_DELAY_COUNTER_MAX then
				nextState <= WriteV200_WriteData_WE1;
				delay <= '0';
			end if;
			
			
		when WriteV200_WriteData_WE1 =>
			write_Data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			DataOut_SM <= data_to_write;
			WE_L_SM <= '1';
			WE_H_SM <= '1';
			
			delay_short <= '1';
			if delay_counter_short = c_DELAY_COUNTER_SHORT_MAX then
				nextState <= WriteV200_ReadStatus_OE0;
				delay_short <= '0';
			end if;
			
		when WriteV200_ReadStatus_OE0 =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '0';
			OE_SM <= '0';
			
			delay_short <= '1';
			if delay_counter_short = c_DELAY_COUNTER_SHORT_MAX then
				nextState <= WriteV200_ReadStatus_getData;
				delay_short <= '0';
			end if;
			
		when WriteV200_ReadStatus_getData =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '0';
			OE_SM <= '0';
			
			get_status <= '1';
			delay <= '1';
			if delay_counter = c_DELAY_COUNTER_MAX then
				nextState <= WriteV200_ReadStatus_checkData;
				delay <= '0';
			end if;
			
		when WriteV200_ReadStatus_checkData =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '0';
			OE_SM <= '1';
			
			--if status = x"0000" then
			--	nextState <= WriteV200_ReadStatus_OE0;
			--else
			--	led_drive_1 <= '1';
			--end if;
			delay_short <= '1';
			if delay_counter_short = c_DELAY_COUNTER_SHORT_MAX then
				if status(15) = '1' and status(7) = '1' then
				--	-- Write data done
					--if status(12) = '1' and status(4) = '1' then
					--	nextState <= ERROR_WRITE;
					--elsif status(11) = '1' and status(3) = '1' then
					--	nextState <= ERROR_VPP;
					--else
						nextState <= WriteV200_StatusOK;
					--end if;
				else
					nextState <= WriteV200_WriteData_WE1;
				end if;
				delay_short <= '0';
			end if;
			
		when WriteV200_StatusOK =>
			write_Data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '0';
			
			inc_start_adress <= '1';
			
			--led_drive_1 <= '1';
			--led_drive_2 <= '1';
			
			delay_short <= '1';
			if delay_counter_short = c_DELAY_COUNTER_SHORT_MAX then
				if startAdress > endAdress then
					nextState <= SetPins;
				else
					--nextState <= WriteV200_done;
					nextState <= WriteV200_ClearStatus_data;
				end if;
				delay_short <= '0';
			end if;
			
		when WriteV200_done =>
			write_data <= '1';
			CE_SM(0) <= '0';
			CE_SM(1) <= '0';
			Adress_SM <= startAdress;
			DATOE_SM <= '1';
			DataOut_SM <= data_to_write;
	
			--if startAdress = b"00000000000000000000000000" then
			--	led_drive_1 <= '1';
			--else
			--	led_drive_2 <= '1';
			--end if;
			
		when ERROR_WRITE =>
			write_data <= '1';
			led_drive_2 <= '1';
			
		when ERROR_VPP =>
			write_data <= '1';
			led_drive_1 <= '1';
		
		when E1 =>
			led_drive_1 <= '1';
			led_drive_2 <= '1';
		
		when E2 =>
			led_drive_1 <= '1';
			led_drive_2 <= '1';
			
		end case;
	end process fsm_comb;

end Behavioral;

